package gov.va.genisis2.bo;

import static org.mockito.Mockito.when;

import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;

/**
 * @author Getaneh Kassahun
 *
 */

public class ActivitiServiceTest extends AbstractMockMvcTests {

	/** User Id. */
	private final String userId = "datamanager1";

	/**
	 * This method is used to getUserId.
	 * @return This returns userId.
	 * 
	 */
	public String getUserId() {
		return userId;
	}

	/**
	 * This method is used to Test work flow process.
	 * @exception Exception On work flow process error.
	 */
	@Test
	public void startProcess() throws Exception {
		ActivitiService activitiService = getMockActivitiService();
		String processId = activitiService.startProcess(getUserId());
		when(activitiService.startProcess(getUserId())).thenReturn(processId);
	}

}
